/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemResourceScroll
extends AbstractItemMinecolonies {
    public ItemResourceScroll(Item.Properties properties) {
        super("resourcescroll", properties.func_200917_a(64).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack scroll = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        CompoundNBT compound = ItemResourceScroll.checkForCompound(scroll);
        TileEntity entity = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        if (entity instanceof TileEntityColonyBuilding) {
            compound.func_74768_a("colony", ((AbstractTileEntityColonyBuilding)entity).getColonyId());
            BlockPosUtil.write(compound, "builder", ((AbstractTileEntityColonyBuilding)entity).getPosition());
            if (!ctx.func_195991_k().field_72995_K) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"com.minecolonies.coremod.item.scroll.registered", (Object[])new Object[]{((AbstractTileEntityColonyBuilding)entity).getColony().getName()});
            }
        } else if (ctx.func_195991_k().field_72995_K) {
            ItemResourceScroll.openWindow(compound, ctx.func_195999_j());
        }
        return ActionResultType.SUCCESS;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack clipboard = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)clipboard);
        }
        ItemResourceScroll.openWindow(ItemResourceScroll.checkForCompound(clipboard), playerIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)clipboard);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IBuildingView buildingView;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (worldIn == null) {
            return;
        }
        CompoundNBT compound = ItemResourceScroll.checkForCompound(stack);
        int colonyId = compound.func_74762_e("colony");
        BlockPos builderPos = BlockPosUtil.read(compound, "builder");
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, (RegistryKey<World>)worldIn.func_234923_W_());
        if (colonyView != null && (buildingView = colonyView.getBuilding(builderPos)) instanceof BuildingBuilder.View) {
            String name = ((BuildingBuilder.View)buildingView).getWorkerName();
            tooltip.add((ITextComponent)(name != null && !name.trim().isEmpty() ? new StringTextComponent(TextFormatting.DARK_PURPLE + name) : new TranslationTextComponent("com.minecolonies.coremod.item.scroll.no_builder")));
        }
    }

    private static CompoundNBT checkForCompound(ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new CompoundNBT());
        }
        return item.func_77978_p();
    }

    private static void openWindow(CompoundNBT compound, PlayerEntity player) {
        if (compound.func_150296_c().contains("colony") && compound.func_150296_c().contains("builder")) {
            int colonyId = compound.func_74762_e("colony");
            BlockPos builderPos = BlockPosUtil.read(compound, "builder");
            MineColonies.proxy.openResourceScrollWindow(colonyId, builderPos);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.scroll.needcolony"), true);
        }
    }
}

